source("D:\\groimp\\rapilibrary\\R\\GroR.R")

library(future)
library(future.apply)
library(sensitivity)

wb1 <- GroLink.open("http://localhost:58081/api", path="Example08.gsz") # copy gsz to groimp path

(functions <- WBRef.listRGGFunctions(wb1))
WBRef.getFile(wb1, "param/parameters.rgg")

## easy example

model_output <- ""
n_grows <- 0
while (!(is.numeric(model_output)) && (n_grows < 200)) {
  result <- WBRef.runRGGFunction(wb1,"grow")
  model_output <- unlist(result$console)
  if (model_output != "no flower"){
    model_output <- as.numeric(model_output)
  }
}


## Model function for real analysis:


executeModel <- function(params, timeout = 200){
  wb1 <- GroLink.open("http://localhost:58081/api", path="Example08.gsz")
  WBRef.updateFile(wb1, "param/parameters.rgg",
                   paste("static float NormalInternodeLength = ", as.character(params[1]),
                         ";\r\nstatic float FlowerInternodeLength = ", as.character(params[2]),
                         ";\r\nstatic float LeafLength = ", as.character(params[3]),
                         ";\r\nstatic float LeafAspectRatio = ", as.character(params[4]),
                         "; \r\nstatic float PlantWideness = ", as.character(params[5]),
                         ";",
                         sep = ""))

  WBRef.compile(wb1)

  model_output <- ""
  n_grows <- 0
  while (!(is.numeric(model_output)) && (n_grows < timeout)) {
    result <- WBRef.runRGGFunction(wb1,"grow")
    model_output <- unlist(result$console)
    if (model_output != "no flower"){
      model_output <- as.numeric(model_output)
    }
    n_grows <- n_grows + 1
  }
  if (n_grows == timeout) {
    model_output <- NA
  }
  WBRef.close(wb1)
  return(model_output)
}

## generating parameter set

m <-    morris(model = NULL, factors = c("NormalInternodeLength", # baseline is 0.1
                                         "FlowerInternodeLength", # baseline is 0.05
                                         "LeafLength",            # baseline is 0.1
                                         "LeafAspectRatio",       # baseline is 0.7
                                         "PlantWideness"),        # baseline is 0.1
               r = 20,                                                 # 20 repetitions
               binf = c(0.05, 0.01, 0.05, 0.1, 0.1),                   # min value of inputs
               bsup = c(0.8, 0.1, 1, 1, 1),                            # max value of inputs
               design = list(type = "oat", levels = 6, grid.jump = 3)) # 6 levels per parameter (check with e.g. length(unique(x$X[,4])))
                                                                       # grid.jump is recommended to be levels/2, see ?morris


params <- m$X

## Applying over the parameter Matrix in parallel

plan(multisession, workers = availableCores())

system.time(model_outputs <- future_apply(params, 1, executeModel))

saveRDS(model_outputs, "example08_morris_outputs.rds")

## Analyze output

sensitivity::tell(m, model_outputs)

plot(m)

